implementation module controldraw


//	Clean Object I/O library, version 1.0.1

//	Drawing in customised controls

import	ospicture, oswindow
import	StdPicture
import	wstateaccess


/*	The following functions apply the current Look function of the given control.
*/

/*	drawCompoundLook able parentWindow itemH
		applies the Look function of the compound control given the current selectstate (True iff Able).
		The function assumes that itemH refers to a CompoundControl which ClipState is valid.
*/
drawCompoundLook :: !Bool !OSWindowPtr !WItemHandle` !*OSToolbox -> (!WItemHandle`,!*OSToolbox)
drawCompoundLook able wPtr itemH=:{wItemInfo`} tb
	| isNothing info.compoundLookInfo
	= (itemH,tb)
	# (osPict,tb)		= OSgrabControlPictContext wPtr itemPtr tb
	# picture			= packPicture origin itemLook.lookPen osPict tb
	# (_,picture)		= pictsetcliprgn itemClip.clipRgn picture
	# picture			= StrictSeq drawFs picture
	# (_,pen,osPict,tb)	= unpackPicture picture
	# tb				= OSreleaseControlPictContext itemPtr osPict tb
	  info				= {info & compoundLookInfo=Just {compoundLookInfo & compoundLook={itemLook & lookPen=pen}}}
	= ({itemH & wItemInfo`=CompoundInfo` info},tb)
where
	itemPtr				= itemH.wItemPtr`
	info				= getWItemCompoundInfo` wItemInfo`
	origin				= info.compoundOrigin
	compoundLookInfo	= fromJust info.compoundLookInfo
	itemLook			= compoundLookInfo.compoundLook
	itemClip			= compoundLookInfo.compoundClip
	itemSize			= itemH.wItemSize`
	frame				= PosSizeToRectangle origin itemSize
	selectState			= if able Able Unable
	drawFs				= itemLook.lookFun selectState (RectangleToUpdateState frame)

/*	drawCustomButtonLook able parentWindow itemH
		applies the Look function of the custom button control given the current selectstate (True iff Able).
		The function assumes that itemH refers to a custom button control.
*/
drawCustomButtonLook :: !Bool !OSWindowPtr !WItemHandle` !*OSToolbox -> (!WItemHandle`,!*OSToolbox)
drawCustomButtonLook able wPtr itemH=:{wItemPtr`,wItemInfo`,wItemSize`} tb
	# (osPict,tb)		= OSgrabControlPictContext wPtr wItemPtr` tb
	# picture			= packPicture zero itemLook.lookPen osPict tb
	# picture			= clip frame drawFs picture
	# (_,pen,osPict,tb)	= unpackPicture picture
	# tb				= OSreleaseControlPictContext wItemPtr` osPict tb
	  info				= CustomButtonInfo` {info & cButtonInfoLook={itemLook & lookPen=pen}}
	= ({itemH & wItemInfo`=info},tb)
where
	info				= getWItemCustomButtonInfo` wItemInfo`
	itemLook			= info.cButtonInfoLook
	frame				= SizeToRectangle wItemSize`
	selectState			= if able Able Unable
	drawFs				= itemLook.lookFun selectState (RectangleToUpdateState frame)

/*	drawCustomLook able parentWindow itemH
		applies the Look function of the custom control given the current selectstate (True iff Able).
		The function assumes that itemH refers to a custom control.
*/
drawCustomLook :: !Bool !OSWindowPtr !WItemHandle` !*OSToolbox -> (!WItemHandle`,!*OSToolbox)
drawCustomLook able wPtr itemH=:{wItemPtr`,wItemInfo`,wItemSize`} tb
	# (osPict,tb)		= OSgrabControlPictContext wPtr wItemPtr` tb
	# picture			= packPicture zero itemLook.lookPen osPict tb
	# picture			= clip frame drawFs picture
	# (_,pen,osPict,tb)	= unpackPicture picture
	# tb				= OSreleaseControlPictContext wItemPtr` osPict tb
	  info				= CustomInfo` {info & customInfoLook={itemLook & lookPen=pen}}
	= ({itemH & wItemInfo`=info},tb)
where
	info				= getWItemCustomInfo` wItemInfo`
	itemLook			= info.customInfoLook
	frame				= SizeToRectangle wItemSize`
	selectState			= if able Able Unable
	drawFs				= itemLook.lookFun selectState (RectangleToUpdateState frame)


/*	The following functions apply a list of drawing functions to the given control.
*/

/*	drawInCompound assumes that the WItemHandle` argument refers to a non transparent compound control 
	with a valid ClipState.
*/
drawInCompound :: !OSWindowPtr ![DrawFunction] !WItemHandle` !*OSToolbox -> (!WItemHandle`,!*OSToolbox)
drawInCompound wPtr drawFs itemH=:{wItemPtr`,wItemInfo`,wItemPos`,wItemSize`} tb
	# (osPict,tb)		= OSgrabControlPictContext wPtr wItemPtr` tb
	# picture			= packPicture origin compoundLook.lookPen osPict tb
	# (_,picture)		= pictsetcliprgn compoundClip.clipRgn picture
	# picture			= StrictSeq drawFs picture
	# (_,pen,osPict,tb)	= unpackPicture picture
	# tb				= OSreleaseControlPictContext wItemPtr` osPict tb
	  info				= {info & compoundLookInfo=Just {compoundLookInfo & compoundLook={compoundLook & lookPen=pen}}}
	  itemH				= {itemH & wItemInfo`=CompoundInfo` info}
	= (itemH,tb)
where
	info				= getWItemCompoundInfo` wItemInfo`
	origin				= info.compoundOrigin
	compoundLookInfo	= fromJust info.compoundLookInfo
	{compoundLook,compoundClip}
						= compoundLookInfo

drawInCustomButton :: !OSWindowPtr ![DrawFunction] !WItemHandle` !*OSToolbox -> (!WItemHandle`,!*OSToolbox)
drawInCustomButton wPtr drawFs itemH=:{wItemPtr`,wItemInfo`,wItemSize`} tb
	# (osPict,tb)		= OSgrabControlPictContext wPtr wItemPtr` tb
	# picture			= packPicture zero itemLook.lookPen osPict tb
	# picture			= clip (SizeToRectangle wItemSize`) drawFs picture
	# (_,pen,osPict,tb)	= unpackPicture picture
	# tb				= OSreleaseControlPictContext wItemPtr` osPict tb
	  info				= {info & cButtonInfoLook={itemLook & lookPen=pen}}
	  itemH				= {itemH & wItemInfo`=CustomButtonInfo` info}
	= (itemH,tb)
where
	info				= getWItemCustomButtonInfo` wItemInfo`
	itemLook			= info.cButtonInfoLook

drawInCustom :: !OSWindowPtr ![DrawFunction] !WItemHandle` !*OSToolbox -> (!WItemHandle`,!*OSToolbox)
drawInCustom wPtr drawFs itemH=:{wItemPtr`,wItemInfo`,wItemSize`} tb
	# (osPict,tb)		= OSgrabControlPictContext wPtr wItemPtr` tb
	# picture			= packPicture zero itemLook.lookPen osPict tb
	# picture			= clip (SizeToRectangle wItemSize`) drawFs picture
	# (_,pen,osPict,tb)	= unpackPicture picture
	# tb				= OSreleaseControlPictContext wItemPtr` osPict tb
	  info				= {info & customInfoLook={itemLook & lookPen=pen}}
	  itemH				= {itemH & wItemInfo`=CustomInfo` info}
	= (itemH,tb)
where
	info				= getWItemCustomInfo` wItemInfo`
	itemLook			= info.customInfoLook
